<?php
/**
 * Routes Configuration
 * Map URL paths to PHP files
 * 
 * Format: 'url-path' => 'file-path'
 * 
 * Example: To access student attendance at domain.com/studentattendance
 * Set: 'studentattendance' => 'student/scan.php'
 */

$routes = [
    // Home/Default
    '' => 'home.php',
    'home' => 'home.php',
    
    // Admin routes
    'admin' => 'admin/login.php',
    'admin/login' => 'admin/login.php',
    'admin/dashboard' => 'admin/dashboard.php',
    'admin/lecturers' => 'admin/lecturers.php',
    'admin/manage' => 'admin/manage.php',
    'admin/logout' => 'admin/logout.php',
    
    // Lecturer routes
    'lecturer' => 'lecturer/login.php',
    'lecturer/register' => 'lecturer/register.php',
    'lecturer/login' => 'lecturer/login.php',
    'lecturer/dashboard' => 'lecturer/dashboard.php',
    'lecturer/assign' => 'lecturer/assign.php',
    'lecturer/qrcode' => 'lecturer/qrcode.php',
    'lecturer/attendance-list' => 'lecturer/attendance-list.php',
    'lecturer/view-attendance' => 'lecturer/view-attendance.php',
    'lecturer/logout' => 'lecturer/logout.php',
    
    // Student routes - Change 'studentattendance' to any path you want
    'studentattendance' => 'student/scan.php',
    'student' => 'student/scan.php',
    'student/scan' => 'student/scan.php',
    
    // API routes for AJAX
    'api/qr-status' => 'api/qr-status.php',
    'api/submit-attendance' => 'api/submit-attendance.php',
    'api/get-departments' => 'api/get-departments.php',
    'api/get-levels' => 'api/get-levels.php',
];

return $routes;
?> 