<?php
require_once __DIR__ . '/../config.php';
require_once __DIR__ . '/../functions.php';

if (!isLecturerLoggedIn()) {
    redirect('lecturer/login');
}

$file = $_GET['file'] ?? '';
$lecturerName = $_SESSION['lecturer_name'];

// Verify file belongs to this lecturer
if (empty($file) || strpos($file, $lecturerName) === false) {
    redirect('lecturer/attendance-list');
}

$records = readAttendanceCSV($file);

// Parse filename for display
$parts = explode('_', pathinfo($file, PATHINFO_FILENAME));
$date = isset($parts[0]) && isset($parts[1]) ? $parts[0] . ' ' . str_replace('-', ':', $parts[1]) : 'Unknown';
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>View Attendance - <?php echo SITE_NAME; ?></title>
    <style>
        * { margin: 0; padding: 0; box-sizing: border-box; }
        body {
            font-family: system-ui, -apple-system, sans-serif;
            background: #F9FAFB;
            min-height: 100vh;
        }
        .navbar {
            background: white;
            padding: 1rem 2rem;
            box-shadow: 0 2px 4px rgba(0,0,0,0.05);
            display: flex;
            justify-content: space-between;
            align-items: center;
            flex-wrap: wrap;
            gap: 1rem;
        }
        .navbar-brand {
            font-size: 1.25rem;
            font-weight: 700;
            color: #4F46E5;
            text-decoration: none;
        }
        .navbar-nav {
            display: flex;
            gap: 1rem;
            flex-wrap: wrap;
        }
        .nav-link {
            color: #6B7280;
            text-decoration: none;
            padding: 0.5rem 1rem;
            border-radius: 6px;
            transition: all 0.3s;
        }
        .nav-link:hover, .nav-link.active {
            background: #EEF2FF;
            color: #4F46E5;
        }
        .nav-link.logout {
            background: #FEE2E2;
            color: #DC2626;
        }
        .container {
            max-width: 1000px;
            margin: 0 auto;
            padding: 2rem;
        }
        .page-header {
            display: flex;
            justify-content: space-between;
            align-items: flex-start;
            flex-wrap: wrap;
            gap: 1rem;
            margin-bottom: 2rem;
        }
        .page-title {
            font-size: 1.5rem;
            font-weight: 700;
            color: #111827;
        }
        .page-subtitle {
            color: #6B7280;
            font-size: 0.9rem;
            margin-top: 0.25rem;
        }
        .btn-group {
            display: flex;
            gap: 0.5rem;
            flex-wrap: wrap;
        }
        .btn {
            padding: 10px 20px;
            border: none;
            border-radius: 8px;
            font-size: 0.95rem;
            font-weight: 500;
            cursor: pointer;
            text-decoration: none;
            transition: all 0.3s;
        }
        .btn-primary {
            background: #4F46E5;
            color: white;
        }
        .btn-primary:hover { background: #4338CA; }
        .btn-success {
            background: #10B981;
            color: white;
        }
        .btn-success:hover { background: #059669; }
        .btn-secondary {
            background: #6B7280;
            color: white;
        }
        .btn-secondary:hover { background: #4B5563; }
        .card {
            background: white;
            border-radius: 12px;
            box-shadow: 0 2px 8px rgba(0,0,0,0.05);
            overflow: hidden;
        }
        .table-container {
            overflow-x: auto;
        }
        table {
            width: 100%;
            border-collapse: collapse;
        }
        th, td {
            padding: 1rem;
            text-align: left;
            border-bottom: 1px solid #E5E7EB;
        }
        th {
            background: #4F46E5;
            color: white;
            font-weight: 600;
        }
        tr:nth-child(even) {
            background: #F9FAFB;
        }
        tr:hover {
            background: #EEF2FF;
        }
        .empty-state {
            text-align: center;
            padding: 3rem;
            color: #6B7280;
        }
        @media (max-width: 768px) {
            .navbar { padding: 1rem; }
            .container { padding: 1rem; }
            th, td { padding: 0.75rem 0.5rem; font-size: 0.85rem; }
            .btn { padding: 8px 12px; font-size: 0.85rem; }
        }
        @media print {
            .navbar, .btn-group { display: none; }
            .container { padding: 0; max-width: 100%; }
            .card { box-shadow: none; }
        }
    </style>
</head>
<body>
    <nav class="navbar">
        <a href="dashboard" class="navbar-brand">👨‍🏫 Lecturer Portal</a>
        <div class="navbar-nav">
            <a href="dashboard" class="nav-link">Dashboard</a>
            <a href="assign" class="nav-link">Take Attendance</a>
            <a href="attendance-list" class="nav-link active">Attendance List</a>
            <a href="logout" class="nav-link logout">Logout</a>
        </div>
    </nav>
    
    <div class="container">
        <div class="page-header">
            <div>
                <h1 class="page-title">📋 Attendance Record</h1>
                <p class="page-subtitle">📄 <?php echo htmlspecialchars($file); ?></p>
                <p class="page-subtitle">📅 <?php echo $date; ?> | 👥 <?php echo count($records); ?> students</p>
            </div>
            <div class="btn-group">
                <a href="attendance-list" class="btn btn-secondary">← Back</a>
                <button onclick="printAsPDF()" class="btn btn-primary">🖨️ Print as PDF</button>
                <button onclick="downloadCSV()" class="btn btn-success">📥 Download CSV</button>
            </div>
        </div>
        
        <div class="card" id="attendanceTable">
            <?php if (empty($records)): ?>
                <div class="empty-state">
                    <p>No attendance records in this file</p>
                </div>
            <?php else: ?>
                <div class="table-container">
                    <table>
                        <thead>
                            <tr>
                                <th>S/N</th>
                                <th>Full Name</th>
                                <th>Matric Number</th>
                                <th>Department</th>
                                <th>Level</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($records as $index => $record): ?>
                                <tr>
                                    <td><?php echo $index + 1; ?></td>
                                    <td><?php echo htmlspecialchars($record['fullname']); ?></td>
                                    <td><?php echo htmlspecialchars($record['matric']); ?></td>
                                    <td><?php echo htmlspecialchars($record['department']); ?></td>
                                    <td><?php echo htmlspecialchars($record['level']); ?></td>
                                </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            <?php endif; ?>
        </div>
    </div>
    
    <script>
        function printAsPDF() {
            window.print();
        }
        
        function downloadCSV() {
            const filename = '<?php echo addslashes($file); ?>';
            const link = document.createElement('a');
            link.href = '../data/attendance/' + filename;
            link.download = filename;
            document.body.appendChild(link);
            link.click();
            document.body.removeChild(link);
        }
    </script>
</body>
</html>