<?php
require_once __DIR__ . '/../config.php';
require_once __DIR__ . '/../functions.php';

// Redirect if already logged in
if (isLecturerLoggedIn()) {
    redirect('lecturer/dashboard');
}

$error = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $email = sanitize($_POST['email'] ?? '');
    $password = $_POST['password'] ?? '';
    
    $lecturer = getLecturerByEmail($email);
    
    if (!$lecturer) {
        $error = 'Account not in existence';
    } elseif (!verifyPassword($password, $lecturer['password'])) {
        $error = 'Incorrect password';
    } else {
        $_SESSION['lecturer_logged_in'] = true;
        $_SESSION['lecturer_id'] = $lecturer['id'];
        $_SESSION['lecturer_email'] = $lecturer['email'];
        $_SESSION['lecturer_name'] = $lecturer['fullname'];
        redirect('lecturer/dashboard');
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Lecturer Login - <?php echo SITE_NAME; ?></title>
    <style>
        * { margin: 0; padding: 0; box-sizing: border-box; }
        body {
            font-family: system-ui, -apple-system, sans-serif;
            background: #F9FAFB;
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 20px;
        }
        .login-card {
            background: white;
            border-radius: 12px;
            box-shadow: 0 4px 20px rgba(0,0,0,0.1);
            padding: 2rem;
            width: 100%;
            max-width: 400px;
        }
        .logo {
            text-align: center;
            margin-bottom: 1.5rem;
        }
        .logo-icon { font-size: 3rem; }
        .logo-text {
            font-size: 1.5rem;
            font-weight: 700;
            color: #4F46E5;
            margin-top: 0.5rem;
        }
        .logo-sub {
            color: #6B7280;
            font-size: 0.9rem;
        }
        .form-group {
            margin-bottom: 1rem;
        }
        label {
            display: block;
            font-weight: 500;
            color: #374151;
            margin-bottom: 0.5rem;
        }
        input {
            width: 100%;
            padding: 12px;
            border: 1px solid #E5E7EB;
            border-radius: 8px;
            font-size: 1rem;
            transition: border-color 0.3s;
        }
        input:focus {
            outline: none;
            border-color: #4F46E5;
        }
        .btn {
            width: 100%;
            padding: 12px;
            background: #4F46E5;
            color: white;
            border: none;
            border-radius: 8px;
            font-size: 1rem;
            font-weight: 600;
            cursor: pointer;
            transition: background 0.3s;
        }
        .btn:hover { background: #4338CA; }
        .error {
            background: #FEE2E2;
            color: #DC2626;
            padding: 10px;
            border-radius: 8px;
            margin-bottom: 1rem;
            text-align: center;
        }
        .links {
            text-align: center;
            margin-top: 1rem;
        }
        .links a {
            color: #4F46E5;
            text-decoration: none;
        }
        .links a:hover { text-decoration: underline; }
        .back-link {
            display: block;
            text-align: center;
            margin-top: 1rem;
            color: #6B7280;
            text-decoration: none;
        }
        .back-link:hover { color: #4F46E5; }
    </style>
</head>
<body>
    <div class="login-card">
        <div class="logo">
            <div class="logo-icon">👨‍🏫</div>
            <div class="logo-text">Lecturer Portal</div>
            <div class="logo-sub">Sign in to continue</div>
        </div>
        
        <?php if ($error): ?>
            <div class="error"><?php echo $error; ?></div>
        <?php endif; ?>
        
        <form method="POST">
            <div class="form-group">
                <label for="email">Email Address</label>
                <input type="email" id="email" name="email" required placeholder="Enter your email">
            </div>
            <div class="form-group">
                <label for="password">Password</label>
                <input type="password" id="password" name="password" required placeholder="Enter your password">
            </div>
            <button type="submit" class="btn">Sign In</button>
        </form>
        <div class="links">
            Don't have an account? <a href="register">Register here</a>
        </div>
        <a href="../" class="back-link">← Back to Home</a>
    </div>
</body>
</html>