<?php
require_once __DIR__ . '/../config.php';
require_once __DIR__ . '/../functions.php';

if (!isLecturerLoggedIn()) {
    redirect('lecturer/login');
}

$lecturerName = $_SESSION['lecturer_name'];
$totalAttendance = countTotalAttendance($lecturerName);
$attendanceFiles = getAttendanceFiles($lecturerName);
$attendanceRecords = count($attendanceFiles);
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Lecturer Dashboard - <?php echo SITE_NAME; ?></title>
    <style>
        * { margin: 0; padding: 0; box-sizing: border-box; }
        body {
            font-family: system-ui, -apple-system, sans-serif;
            background: #F9FAFB;
            min-height: 100vh;
        }
        .navbar {
            background: white;
            padding: 1rem 2rem;
            box-shadow: 0 2px 4px rgba(0,0,0,0.05);
            display: flex;
            justify-content: space-between;
            align-items: center;
            flex-wrap: wrap;
            gap: 1rem;
        }
        .navbar-brand {
            font-size: 1.25rem;
            font-weight: 700;
            color: #4F46E5;
            text-decoration: none;
        }
        .navbar-nav {
            display: flex;
            gap: 1rem;
            flex-wrap: wrap;
        }
        .nav-link {
            color: #6B7280;
            text-decoration: none;
            padding: 0.5rem 1rem;
            border-radius: 6px;
            transition: all 0.3s;
        }
        .nav-link:hover, .nav-link.active {
            background: #EEF2FF;
            color: #4F46E5;
        }
        .nav-link.logout {
            background: #FEE2E2;
            color: #DC2626;
        }
        .nav-link.logout:hover {
            background: #FECACA;
        }
        .container {
            max-width: 1200px;
            margin: 0 auto;
            padding: 2rem;
        }
        .welcome {
            margin-bottom: 2rem;
        }
        .welcome h1 {
            font-size: 1.75rem;
            font-weight: 700;
            color: #111827;
        }
        .welcome p {
            color: #6B7280;
            margin-top: 0.25rem;
        }
        .stats-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
            gap: 1.5rem;
            margin-bottom: 2rem;
        }
        .stat-card {
            background: white;
            border-radius: 12px;
            padding: 1.5rem;
            box-shadow: 0 2px 8px rgba(0,0,0,0.05);
        }
        .stat-icon {
            font-size: 2.5rem;
            margin-bottom: 0.5rem;
        }
        .stat-value {
            font-size: 2rem;
            font-weight: 700;
            color: #111827;
        }
        .stat-label {
            color: #6B7280;
            font-size: 0.9rem;
        }
        .quick-actions {
            background: white;
            border-radius: 12px;
            padding: 1.5rem;
            box-shadow: 0 2px 8px rgba(0,0,0,0.05);
        }
        .quick-actions h3 {
            margin-bottom: 1rem;
            color: #374151;
        }
        .action-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
            gap: 1rem;
        }
        .action-btn {
            display: flex;
            align-items: center;
            gap: 0.75rem;
            padding: 1rem;
            background: #F9FAFB;
            border: 1px solid #E5E7EB;
            border-radius: 8px;
            text-decoration: none;
            color: #374151;
            transition: all 0.3s;
        }
        .action-btn:hover {
            background: #EEF2FF;
            border-color: #4F46E5;
            color: #4F46E5;
        }
        .action-btn.primary {
            background: #4F46E5;
            color: white;
            border-color: #4F46E5;
        }
        .action-btn.primary:hover {
            background: #4338CA;
        }
        .action-icon { font-size: 1.5rem; }
        @media (max-width: 768px) {
            .navbar { padding: 1rem; }
            .container { padding: 1rem; }
        }
    </style>
</head>
<body>
    <nav class="navbar">
        <a href="dashboard" class="navbar-brand">👨‍🏫 Lecturer Portal</a>
        <div class="navbar-nav">
            <a href="dashboard" class="nav-link active">Dashboard</a>
            <a href="assign" class="nav-link">Take Attendance</a>
            <a href="attendance-list" class="nav-link">Attendance List</a>
            <a href="logout" class="nav-link logout">Logout</a>
        </div>
    </nav>
    
    <div class="container">
        <div class="welcome">
            <h1>Welcome, <?php echo htmlspecialchars($lecturerName); ?>!</h1>
            <p>Here's an overview of your attendance records</p>
        </div>
        
        <div class="stats-grid">
            <div class="stat-card">
                <div class="stat-icon">✅</div>
                <div class="stat-value"><?php echo $totalAttendance; ?></div>
                <div class="stat-label">Cumulative Attendance Collected</div>
            </div>
            <div class="stat-card">
                <div class="stat-icon">📋</div>
                <div class="stat-value"><?php echo $attendanceRecords; ?></div>
                <div class="stat-label">Attendance Sessions</div>
            </div>
        </div>
        
        <div class="quick-actions">
            <h3>Quick Actions</h3>
            <div class="action-grid">
                <a href="assign" class="action-btn primary">
                    <span class="action-icon">📝</span>
                    <span>Start New Attendance</span>
                </a>
                <a href="attendance-list" class="action-btn">
                    <span class="action-icon">📊</span>
                    <span>View Attendance Records</span>
                </a>
            </div>
        </div>
    </div>
</body>
</html>