<?php
require_once __DIR__ . '/../config.php';
require_once __DIR__ . '/../functions.php';

if (!isLecturerLoggedIn()) {
    redirect('lecturer/login');
}

$lecturerName = $_SESSION['lecturer_name'];
$attendanceFiles = getAttendanceFiles($lecturerName);

// Sort by date (newest first)
rsort($attendanceFiles);
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Attendance List - <?php echo SITE_NAME; ?></title>
    <style>
        * { margin: 0; padding: 0; box-sizing: border-box; }
        body {
            font-family: system-ui, -apple-system, sans-serif;
            background: #F9FAFB;
            min-height: 100vh;
        }
        .navbar {
            background: white;
            padding: 1rem 2rem;
            box-shadow: 0 2px 4px rgba(0,0,0,0.05);
            display: flex;
            justify-content: space-between;
            align-items: center;
            flex-wrap: wrap;
            gap: 1rem;
        }
        .navbar-brand {
            font-size: 1.25rem;
            font-weight: 700;
            color: #4F46E5;
            text-decoration: none;
        }
        .navbar-nav {
            display: flex;
            gap: 1rem;
            flex-wrap: wrap;
        }
        .nav-link {
            color: #6B7280;
            text-decoration: none;
            padding: 0.5rem 1rem;
            border-radius: 6px;
            transition: all 0.3s;
        }
        .nav-link:hover, .nav-link.active {
            background: #EEF2FF;
            color: #4F46E5;
        }
        .nav-link.logout {
            background: #FEE2E2;
            color: #DC2626;
        }
        .container {
            max-width: 1000px;
            margin: 0 auto;
            padding: 2rem;
        }
        .page-title {
            font-size: 1.75rem;
            font-weight: 700;
            color: #111827;
            margin-bottom: 2rem;
        }
        .card {
            background: white;
            border-radius: 12px;
            box-shadow: 0 2px 8px rgba(0,0,0,0.05);
            overflow: hidden;
        }
        .attendance-item {
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding: 1rem 1.5rem;
            border-bottom: 1px solid #E5E7EB;
            flex-wrap: wrap;
            gap: 1rem;
        }
        .attendance-item:last-child { border-bottom: none; }
        .attendance-item:hover { background: #F9FAFB; }
        .attendance-info {
            flex: 1;
            min-width: 200px;
        }
        .attendance-name {
            font-weight: 600;
            color: #111827;
            word-break: break-all;
            font-size: 0.95rem;
        }
        .attendance-meta {
            font-size: 0.85rem;
            color: #6B7280;
            margin-top: 0.25rem;
        }
        .btn {
            padding: 8px 16px;
            border: none;
            border-radius: 6px;
            font-size: 0.9rem;
            font-weight: 500;
            cursor: pointer;
            text-decoration: none;
            transition: all 0.3s;
        }
        .btn-primary {
            background: #4F46E5;
            color: white;
        }
        .btn-primary:hover { background: #4338CA; }
        .empty-state {
            text-align: center;
            padding: 3rem;
            color: #6B7280;
        }
        .empty-icon {
            font-size: 3rem;
            margin-bottom: 1rem;
        }
        @media (max-width: 768px) {
            .navbar { padding: 1rem; }
            .container { padding: 1rem; }
            .attendance-item { padding: 1rem; }
        }
    </style>
</head>
<body>
    <nav class="navbar">
        <a href="dashboard" class="navbar-brand">👨‍🏫 Lecturer Portal</a>
        <div class="navbar-nav">
            <a href="dashboard" class="nav-link">Dashboard</a>
            <a href="assign" class="nav-link">Take Attendance</a>
            <a href="attendance-list" class="nav-link active">Attendance List</a>
            <a href="logout" class="nav-link logout">Logout</a>
        </div>
    </nav>
    
    <div class="container">
        <h1 class="page-title">📊 Attendance Records</h1>
        
        <div class="card">
            <?php if (empty($attendanceFiles)): ?>
                <div class="empty-state">
                    <div class="empty-icon">📋</div>
                    <p>No attendance records yet</p>
                    <p><a href="assign" style="color: #4F46E5;">Start taking attendance</a></p>
                </div>
            <?php else: ?>
                <?php foreach ($attendanceFiles as $file): ?>
                    <?php
                    // Parse filename: timestamp_faculty_department_course_lecturer.csv
                    $parts = explode('_', pathinfo($file, PATHINFO_FILENAME));
                    $date = isset($parts[0]) && isset($parts[1]) ? $parts[0] . ' ' . str_replace('-', ':', $parts[1]) : 'Unknown';
                    $records = readAttendanceCSV($file);
                    $studentCount = count($records);
                    ?>
                    <div class="attendance-item">
                        <div class="attendance-info">
                            <div class="attendance-name">📄 <?php echo htmlspecialchars($file); ?></div>
                            <div class="attendance-meta">
                                📅 <?php echo $date; ?> | 👥 <?php echo $studentCount; ?> students
                            </div>
                        </div>
                        <a href="view-attendance?file=<?php echo urlencode($file); ?>" class="btn btn-primary">👁️ VIEW</a>
                    </div>
                <?php endforeach; ?>
            <?php endif; ?>
        </div>
    </div>
</body>
</html>