<?php
/**
 * Main Router/Entry Point
 * All requests go through this file
 */

require_once __DIR__ . '/config.php';
require_once __DIR__ . '/functions.php';

// Get routes
$routes = require __DIR__ . '/routes.php';

// Get the requested path
$requestUri = $_SERVER['REQUEST_URI'];
$scriptName = dirname($_SERVER['SCRIPT_NAME']);

// Remove base path and query string
$path = parse_url($requestUri, PHP_URL_PATH);
$path = str_replace($scriptName, '', $path);
$path = trim($path, '/');

// Find matching route
if (isset($routes[$path])) {
    $file = __DIR__ . '/' . $routes[$path];
    if (file_exists($file)) {
        require $file;
        exit;
    }
}

// Check if it's a direct file request
$directFile = __DIR__ . '/' . $path . '.php';
if (file_exists($directFile)) {
    require $directFile;
    exit;
}

// Check subdirectory
$directFile = __DIR__ . '/' . $path;
if (file_exists($directFile) && pathinfo($directFile, PATHINFO_EXTENSION) === 'php') {
    require $directFile;
    exit;
}

// Default to home or 404
if (empty($path)) {
    require __DIR__ . '/home.php';
} else {
    http_response_code(404);
    echo '<!DOCTYPE html><html><head><title>404 Not Found</title></head><body><h1>404 - Page Not Found</h1><p>The page you requested was not found.</p><a href="/">Go Home</a></body></html>';
}
?>