<?php
require_once __DIR__ . '/config.php';
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo SITE_NAME; ?></title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        body {
            font-family: system-ui, -apple-system, sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 20px;
        }
        .container {
            text-align: center;
            max-width: 600px;
        }
        h1 {
            color: white;
            font-size: 2.5rem;
            margin-bottom: 1rem;
            text-shadow: 2px 2px 4px rgba(0,0,0,0.2);
        }
        p {
            color: rgba(255,255,255,0.9);
            font-size: 1.1rem;
            margin-bottom: 2rem;
        }
        .cards {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(150px, 1fr));
            gap: 1rem;
        }
        .card {
            background: white;
            border-radius: 12px;
            padding: 2rem 1rem;
            text-decoration: none;
            color: #333;
            transition: transform 0.3s, box-shadow 0.3s;
            box-shadow: 0 4px 6px rgba(0,0,0,0.1);
        }
        .card:hover {
            transform: translateY(-5px);
            box-shadow: 0 8px 25px rgba(0,0,0,0.2);
        }
        .card-icon {
            font-size: 2.5rem;
            margin-bottom: 0.5rem;
        }
        .card-title {
            font-weight: 600;
            font-size: 1.1rem;
            color: #4F46E5;
        }
        .card-desc {
            font-size: 0.85rem;
            color: #6B7280;
            margin-top: 0.5rem;
        }
    </style>
</head>
<body>
    <div class="container">
        <h1>📋 <?php echo SITE_NAME; ?></h1>
        <p>Select your portal to continue</p>
        <div class="cards">
            <a href="admin/login" class="card">
                <div class="card-icon">👨‍💼</div>
                <div class="card-title">Admin</div>
                <div class="card-desc">Manage system</div>
            </a>
            <a href="lecturer/login" class="card">
                <div class="card-icon">👨‍🏫</div>
                <div class="card-title">Lecturer</div>
                <div class="card-desc">Take attendance</div>
            </a>
            <a href="studentattendance" class="card">
                <div class="card-icon">👨‍🎓</div>
                <div class="card-title">Student</div>
                <div class="card-desc">Mark attendance</div>
            </a>
        </div>
    </div>
</body>
</html>