<?php
/**
 * Configuration File
 * Contains system-wide settings and constants
 */

// Start session if not already started
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// Base path configuration
define('BASE_PATH', __DIR__);
define('DATA_PATH', BASE_PATH . '/data');
define('ATTENDANCE_PATH', DATA_PATH . '/attendance');

// Admin default credentials (change these)
define('ADMIN_EMAIL', 'admin@gmail.com');
define('ADMIN_PASSWORD', '123456'); // Change this in production

// QR Code settings
define('QR_VALIDITY_SECONDS', 5);

// Site settings
define('SITE_NAME', 'Attendance Management System');

// Ensure data directories exist
if (!file_exists(DATA_PATH)) {
    mkdir(DATA_PATH, 0755, true);
}
if (!file_exists(ATTENDANCE_PATH)) {
    mkdir(ATTENDANCE_PATH, 0755, true);
}

// Initialize data files if they don't exist
$dataFiles = [
    'admin.json' => json_encode(['email' => ADMIN_EMAIL, 'password' => password_hash(ADMIN_PASSWORD, PASSWORD_DEFAULT)]),
    'lecturers.json' => json_encode([]),
    'faculties.json' => json_encode([]),
    'departments.json' => json_encode([]),
    'levels.json' => json_encode([]),
    'courses.json' => json_encode([])
];

foreach ($dataFiles as $file => $defaultContent) {
    $filePath = DATA_PATH . '/' . $file;
    if (!file_exists($filePath)) {
        file_put_contents($filePath, $defaultContent);
    }
}
?>