<?php
require_once __DIR__ . '/../config.php';
require_once __DIR__ . '/../functions.php';

header('Content-Type: application/json');

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(['success' => false, 'message' => 'Invalid request method']);
    exit;
}

$token = $_POST['token'] ?? '';
$fullname = sanitize($_POST['fullname'] ?? '');
$matric = sanitize($_POST['matric'] ?? '');
$department = sanitize($_POST['department'] ?? '');
$level = sanitize($_POST['level'] ?? '');
$fingerprint = $_POST['fingerprint'] ?? '';

// Validate required fields
if (empty($fullname) || empty($matric) || empty($department) || empty($level)) {
    echo json_encode(['success' => false, 'message' => 'All fields are required']);
    exit;
}

// Get active session
$session = getActiveQRSession();

if (!$session) {
    echo json_encode(['success' => false, 'message' => 'No active attendance session']);
    exit;
}

if ($session['status'] !== 'active') {
    echo json_encode(['success' => false, 'message' => 'Attendance session has ended']);
    exit;
}

// Check if this device/student already submitted
$existingFingerprints = array_column($session['attendance'], 'fingerprint');
if (in_array($fingerprint, $existingFingerprints)) {
    echo json_encode(['success' => false, 'message' => 'You have already marked attendance']);
    exit;
}

// Check if matric number already submitted
$existingMatrics = array_column($session['attendance'], 'matric');
if (in_array($matric, $existingMatrics)) {
    echo json_encode(['success' => false, 'message' => 'This matric number has already been used']);
    exit;
}

// Add attendance record
$session['attendance'][] = [
    'fullname' => $fullname,
    'matric' => $matric,
    'department' => $department,
    'level' => $level,
    'fingerprint' => $fingerprint,
    'submitted_at' => date('Y-m-d H:i:s')
];

// Save updated session
saveQRSession($session);

echo json_encode([
    'success' => true,
    'message' => 'Attendance submitted successfully'
]);
?>