<?php
require_once __DIR__ . '/../config.php';
require_once __DIR__ . '/../functions.php';

header('Content-Type: application/json');

$action = $_POST['action'] ?? $_GET['action'] ?? '';

if ($action === 'validate_token') {
    $token = $_POST['token'] ?? $_GET['token'] ?? '';
    
    $session = getActiveQRSession();
    
    if (!$session) {
        echo json_encode(['success' => false, 'message' => 'No active attendance session']);
        exit;
    }
    
    if ($session['status'] !== 'active') {
        echo json_encode(['success' => false, 'message' => 'Attendance session has ended']);
        exit;
    }
    
    // Check if token is current or was recently used
    if ($token !== $session['qr_token']) {
        // Check if token was already used
        if (in_array($token, $session['used_tokens'] ?? [])) {
            echo json_encode(['success' => false, 'message' => 'QR code used, scan another']);
            exit;
        }
        echo json_encode(['success' => false, 'message' => 'QR code expired, scan the new one']);
        exit;
    }
    
    // Token is valid - mark it as used and generate new one
    $session['used_tokens'][] = $token;
    $session['qr_token'] = generateQRToken();
    $session['qr_generated_at'] = time();
    saveQRSession($session);
    
    // Return session data for form
    echo json_encode([
        'success' => true,
        'session' => [
            'faculties' => $session['faculties'],
            'departments' => $session['departments'],
            'levels' => $session['levels'],
            'course' => $session['course'],
            'lecturer_name' => $session['lecturer_name']
        ]
    ]);
    exit;
}

if ($action === 'get_session') {
    $session = getActiveQRSession();
    
    if ($session && $session['status'] === 'active') {
        echo json_encode([
            'success' => true,
            'session' => [
                'faculties' => $session['faculties'],
                'departments' => $session['departments'],
                'levels' => $session['levels'],
                'course' => $session['course'],
                'lecturer_name' => $session['lecturer_name']
            ]
        ]);
    } else {
        echo json_encode(['success' => false, 'message' => 'No active session']);
    }
    exit;
}

echo json_encode(['success' => false, 'message' => 'Invalid action']);
?>