<?php
require_once __DIR__ . '/../config.php';
require_once __DIR__ . '/../functions.php';

header('Content-Type: application/json');

$departmentIds = $_POST['department_ids'] ?? $_GET['department_ids'] ?? '';

if (empty($departmentIds)) {
    echo json_encode([]);
    exit;
}

$departmentIdArray = explode(',', $departmentIds);
$levels = getLevels();

$filtered = array_filter($levels, function($level) use ($departmentIdArray) {
    return in_array($level['department_id'], $departmentIdArray);
});

// Remove duplicates by name
$uniqueLevels = [];
$levelNames = [];
foreach ($filtered as $level) {
    if (!in_array($level['name'], $levelNames)) {
        $levelNames[] = $level['name'];
        $uniqueLevels[] = $level;
    }
}

// Sort by level number
usort($uniqueLevels, function($a, $b) {
    $numA = intval(preg_replace('/[^0-9]/', '', $a['name']));
    $numB = intval(preg_replace('/[^0-9]/', '', $b['name']));
    return $numA - $numB;
});

echo json_encode($uniqueLevels);
?>