<?php
require_once __DIR__ . '/../config.php';
require_once __DIR__ . '/../functions.php';

if (!isAdminLoggedIn()) {
    redirect('admin/login');
}

$tab = $_GET['tab'] ?? 'faculty';
$message = '';
$error = '';

// Handle form submissions
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $action = $_POST['action'] ?? '';
    
    switch ($action) {
        case 'add_faculty':
            $name = sanitize($_POST['name'] ?? '');
            if ($name) {
                addFaculty($name);
                $message = 'Faculty added successfully';
            }
            break;
            
        case 'delete_faculty':
            $id = $_POST['id'] ?? '';
            if ($id) {
                deleteFaculty($id);
                $message = 'Faculty deleted successfully';
            }
            break;
            
        case 'add_department':
            $name = sanitize($_POST['name'] ?? '');
            $facultyId = $_POST['faculty_id'] ?? '';
            if ($name && $facultyId) {
                addDepartment($name, $facultyId);
                $message = 'Department added successfully';
            }
            break;
            
        case 'delete_department':
            $id = $_POST['id'] ?? '';
            if ($id) {
                deleteDepartment($id);
                $message = 'Department deleted successfully';
            }
            break;
            
        case 'add_level':
            $name = sanitize($_POST['name'] ?? '');
            $departmentId = $_POST['department_id'] ?? '';
            if ($name && $departmentId) {
                addLevel($name, $departmentId);
                $message = 'Level added successfully';
            }
            break;
            
        case 'delete_level':
            $id = $_POST['id'] ?? '';
            if ($id) {
                deleteLevel($id);
                $message = 'Level deleted successfully';
            }
            break;
            
        case 'add_course':
            $name = sanitize($_POST['name'] ?? '');
            $code = sanitize($_POST['code'] ?? '');
            if ($name && $code) {
                addCourse($name, $code);
                $message = 'Course added successfully';
            }
            break;
            
        case 'delete_course':
            $id = $_POST['id'] ?? '';
            if ($id) {
                deleteCourse($id);
                $message = 'Course deleted successfully';
            }
            break;
    }
}

$faculties = getFaculties();
$departments = getDepartments();
$levels = getLevels();
$courses = getCourses();
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Manage - <?php echo SITE_NAME; ?></title>
    <style>
        * { margin: 0; padding: 0; box-sizing: border-box; }
        body {
            font-family: system-ui, -apple-system, sans-serif;
            background: #F9FAFB;
            min-height: 100vh;
        }
        .navbar {
            background: white;
            padding: 1rem 2rem;
            box-shadow: 0 2px 4px rgba(0,0,0,0.05);
            display: flex;
            justify-content: space-between;
            align-items: center;
            flex-wrap: wrap;
            gap: 1rem;
        }
        .navbar-brand {
            font-size: 1.25rem;
            font-weight: 700;
            color: #4F46E5;
            text-decoration: none;
        }
        .navbar-nav {
            display: flex;
            gap: 1rem;
            flex-wrap: wrap;
        }
        .nav-link {
            color: #6B7280;
            text-decoration: none;
            padding: 0.5rem 1rem;
            border-radius: 6px;
            transition: all 0.3s;
        }
        .nav-link:hover, .nav-link.active {
            background: #EEF2FF;
            color: #4F46E5;
        }
        .nav-link.logout {
            background: #FEE2E2;
            color: #DC2626;
        }
        .container {
            max-width: 1200px;
            margin: 0 auto;
            padding: 2rem;
        }
        .page-title {
            font-size: 1.75rem;
            font-weight: 700;
            color: #111827;
            margin-bottom: 1rem;
        }
        .tabs {
            display: flex;
            gap: 0.5rem;
            margin-bottom: 1.5rem;
            flex-wrap: wrap;
        }
        .tab {
            padding: 0.75rem 1.5rem;
            background: white;
            border: 1px solid #E5E7EB;
            border-radius: 8px;
            text-decoration: none;
            color: #6B7280;
            font-weight: 500;
            transition: all 0.3s;
        }
        .tab:hover, .tab.active {
            background: #4F46E5;
            color: white;
            border-color: #4F46E5;
        }
        .card {
            background: white;
            border-radius: 12px;
            box-shadow: 0 2px 8px rgba(0,0,0,0.05);
            padding: 1.5rem;
            margin-bottom: 1.5rem;
        }
        .card-title {
            font-size: 1.1rem;
            font-weight: 600;
            color: #374151;
            margin-bottom: 1rem;
        }
        .form-row {
            display: flex;
            gap: 1rem;
            flex-wrap: wrap;
        }
        .form-group {
            flex: 1;
            min-width: 200px;
        }
        label {
            display: block;
            font-weight: 500;
            color: #374151;
            margin-bottom: 0.5rem;
            font-size: 0.9rem;
        }
        input, select {
            width: 100%;
            padding: 10px 12px;
            border: 1px solid #E5E7EB;
            border-radius: 8px;
            font-size: 1rem;
        }
        input:focus, select:focus {
            outline: none;
            border-color: #4F46E5;
        }
        .btn {
            padding: 10px 20px;
            border: none;
            border-radius: 8px;
            font-size: 0.95rem;
            font-weight: 500;
            cursor: pointer;
            transition: all 0.3s;
        }
        .btn-primary {
            background: #4F46E5;
            color: white;
        }
        .btn-primary:hover { background: #4338CA; }
        .btn-danger {
            background: #EF4444;
            color: white;
            padding: 6px 12px;
            font-size: 0.85rem;
        }
        .btn-danger:hover { background: #DC2626; }
        .message {
            padding: 12px;
            border-radius: 8px;
            margin-bottom: 1rem;
        }
        .message.success {
            background: #D1FAE5;
            color: #065F46;
        }
        .message.error {
            background: #FEE2E2;
            color: #DC2626;
        }
        .list-item {
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding: 0.75rem;
            border-bottom: 1px solid #E5E7EB;
        }
        .list-item:last-child { border-bottom: none; }
        .list-item-info {
            flex: 1;
        }
        .list-item-name {
            font-weight: 500;
            color: #111827;
        }
        .list-item-sub {
            font-size: 0.85rem;
            color: #6B7280;
        }
        .empty-state {
            text-align: center;
            padding: 2rem;
            color: #6B7280;
        }
        @media (max-width: 768px) {
            .navbar { padding: 1rem; }
            .container { padding: 1rem; }
            .form-row { flex-direction: column; }
        }
    </style>
</head>
<body>
    <nav class="navbar">
        <a href="dashboard" class="navbar-brand">👨‍💼 Admin Panel</a>
        <div class="navbar-nav">
            <a href="dashboard" class="nav-link">Dashboard</a>
            <a href="lecturers" class="nav-link">Lecturers</a>
            <a href="manage" class="nav-link active">Manage</a>
            <a href="logout" class="nav-link logout">Logout</a>
        </div>
    </nav>
    
    <div class="container">
        <h1 class="page-title">Manage System</h1>
        
        <?php if ($message): ?>
            <div class="message success"><?php echo $message; ?></div>
        <?php endif; ?>
        
        <?php if ($error): ?>
            <div class="message error"><?php echo $error; ?></div>
        <?php endif; ?>
        
        <div class="tabs">
            <a href="?tab=faculty" class="tab <?php echo $tab === 'faculty' ? 'active' : ''; ?>">🏛️ Faculties</a>
            <a href="?tab=department" class="tab <?php echo $tab === 'department' ? 'active' : ''; ?>">🏢 Departments</a>
            <a href="?tab=level" class="tab <?php echo $tab === 'level' ? 'active' : ''; ?>">📊 Levels</a>
            <a href="?tab=course" class="tab <?php echo $tab === 'course' ? 'active' : ''; ?>">📚 Courses</a>
        </div>
        
        <?php if ($tab === 'faculty'): ?>
            <!-- Faculty Management -->
            <div class="card">
                <h3 class="card-title">Add New Faculty</h3>
                <form method="POST">
                    <input type="hidden" name="action" value="add_faculty">
                    <div class="form-row">
                        <div class="form-group">
                            <label>Faculty Name</label>
                            <input type="text" name="name" required placeholder="e.g., Faculty of Science">
                        </div>
                        <div class="form-group" style="flex: 0; display: flex; align-items: flex-end;">
                            <button type="submit" class="btn btn-primary">Add Faculty</button>
                        </div>
                    </div>
                </form>
            </div>
            
            <div class="card">
                <h3 class="card-title">Existing Faculties</h3>
                <?php if (empty($faculties)): ?>
                    <div class="empty-state">No faculties added yet</div>
                <?php else: ?>
                    <?php foreach ($faculties as $faculty): ?>
                        <div class="list-item">
                            <div class="list-item-info">
                                <div class="list-item-name"><?php echo htmlspecialchars($faculty['name']); ?></div>
                            </div>
                            <form method="POST" style="display: inline;" onsubmit="return confirm('Delete this faculty?');">
                                <input type="hidden" name="action" value="delete_faculty">
                                <input type="hidden" name="id" value="<?php echo $faculty['id']; ?>">
                                <button type="submit" class="btn btn-danger">Delete</button>
                            </form>
                        </div>
                    <?php endforeach; ?>
                <?php endif; ?>
            </div>
            
        <?php elseif ($tab === 'department'): ?>
            <!-- Department Management -->
            <div class="card">
                <h3 class="card-title">Add New Department</h3>
                <form method="POST">
                    <input type="hidden" name="action" value="add_department">
                    <div class="form-row">
                        <div class="form-group">
                            <label>Select Faculty</label>
                            <select name="faculty_id" required>
                                <option value="">-- Select Faculty --</option>
                                <?php foreach ($faculties as $faculty): ?>
                                    <option value="<?php echo $faculty['id']; ?>"><?php echo htmlspecialchars($faculty['name']); ?></option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                        <div class="form-group">
                            <label>Department Name</label>
                            <input type="text" name="name" required placeholder="e.g., Computer Science">
                        </div>
                        <div class="form-group" style="flex: 0; display: flex; align-items: flex-end;">
                            <button type="submit" class="btn btn-primary">Add Department</button>
                        </div>
                    </div>
                </form>
            </div>
            
            <div class="card">
                <h3 class="card-title">Existing Departments</h3>
                <?php if (empty($departments)): ?>
                    <div class="empty-state">No departments added yet</div>
                <?php else: ?>
                    <?php foreach ($departments as $dept): ?>
                        <?php 
                        $facultyName = '';
                        foreach ($faculties as $f) {
                            if ($f['id'] === $dept['faculty_id']) {
                                $facultyName = $f['name'];
                                break;
                            }
                        }
                        ?>
                        <div class="list-item">
                            <div class="list-item-info">
                                <div class="list-item-name"><?php echo htmlspecialchars($dept['name']); ?></div>
                                <div class="list-item-sub">Faculty: <?php echo htmlspecialchars($facultyName); ?></div>
                            </div>
                            <form method="POST" style="display: inline;" onsubmit="return confirm('Delete this department?');">
                                <input type="hidden" name="action" value="delete_department">
                                <input type="hidden" name="id" value="<?php echo $dept['id']; ?>">
                                <button type="submit" class="btn btn-danger">Delete</button>
                            </form>
                        </div>
                    <?php endforeach; ?>
                <?php endif; ?>
            </div>
            
        <?php elseif ($tab === 'level'): ?>
            <!-- Level Management -->
            <div class="card">
                <h3 class="card-title">Add New Level</h3>
                <form method="POST">
                    <input type="hidden" name="action" value="add_level">
                    <div class="form-row">
                        <div class="form-group">
                            <label>Select Department</label>
                            <select name="department_id" required>
                                <option value="">-- Select Department --</option>
                                <?php foreach ($departments as $dept): ?>
                                    <option value="<?php echo $dept['id']; ?>"><?php echo htmlspecialchars($dept['name']); ?></option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                        <div class="form-group">
                            <label>Level Name</label>
                            <input type="text" name="name" required placeholder="e.g., 100-Level">
                        </div>
                        <div class="form-group" style="flex: 0; display: flex; align-items: flex-end;">
                            <button type="submit" class="btn btn-primary">Add Level</button>
                        </div>
                    </div>
                </form>
            </div>
            
            <div class="card">
                <h3 class="card-title">Existing Levels</h3>
                <?php if (empty($levels)): ?>
                    <div class="empty-state">No levels added yet</div>
                <?php else: ?>
                    <?php foreach ($levels as $level): ?>
                        <?php 
                        $deptName = '';
                        foreach ($departments as $d) {
                            if ($d['id'] === $level['department_id']) {
                                $deptName = $d['name'];
                                break;
                            }
                        }
                        ?>
                        <div class="list-item">
                            <div class="list-item-info">
                                <div class="list-item-name"><?php echo htmlspecialchars($level['name']); ?></div>
                                <div class="list-item-sub">Department: <?php echo htmlspecialchars($deptName); ?></div>
                            </div>
                            <form method="POST" style="display: inline;" onsubmit="return confirm('Delete this level?');">
                                <input type="hidden" name="action" value="delete_level">
                                <input type="hidden" name="id" value="<?php echo $level['id']; ?>">
                                <button type="submit" class="btn btn-danger">Delete</button>
                            </form>
                        </div>
                    <?php endforeach; ?>
                <?php endif; ?>
            </div>
            
        <?php elseif ($tab === 'course'): ?>
            <!-- Course Management -->
            <div class="card">
                <h3 class="card-title">Add New Course</h3>
                <form method="POST">
                    <input type="hidden" name="action" value="add_course">
                    <div class="form-row">
                        <div class="form-group">
                            <label>Course Code</label>
                            <input type="text" name="code" required placeholder="e.g., CSC101">
                        </div>
                        <div class="form-group">
                            <label>Course Name</label>
                            <input type="text" name="name" required placeholder="e.g., Introduction to Computer Science">
                        </div>
                        <div class="form-group" style="flex: 0; display: flex; align-items: flex-end;">
                            <button type="submit" class="btn btn-primary">Add Course</button>
                        </div>
                    </div>
                </form>
            </div>
            
            <div class="card">
                <h3 class="card-title">Existing Courses</h3>
                <?php if (empty($courses)): ?>
                    <div class="empty-state">No courses added yet</div>
                <?php else: ?>
                    <?php foreach ($courses as $course): ?>
                        <div class="list-item">
                            <div class="list-item-info">
                                <div class="list-item-name"><?php echo htmlspecialchars($course['code']); ?> - <?php echo htmlspecialchars($course['name']); ?></div>
                            </div>
                            <form method="POST" style="display: inline;" onsubmit="return confirm('Delete this course?');">
                                <input type="hidden" name="action" value="delete_course">
                                <input type="hidden" name="id" value="<?php echo $course['id']; ?>">
                                <button type="submit" class="btn btn-danger">Delete</button>
                            </form>
                        </div>
                    <?php endforeach; ?>
                <?php endif; ?>
            </div>
        <?php endif; ?>
    </div>
</body>
</html>