# Attendance Management System

A PHP-based attendance management system with QR code scanning functionality for educational institutions.

## Features

### Admin Portal
- Login with secure authentication
- Dashboard showing lecturer count and attendance statistics
- View list of registered lecturers (Name and Email)
- Manage Faculties, Departments, Levels, and Courses
- Add/Delete operations for all entities

### Lecturer Portal
- Registration with Full Name, Email, Password
- Login with email verification
- Dashboard showing cumulative attendance collected
- Attendance Assignment with cascading selection:
  - Multiple Faculty selection
  - Multiple Department selection (filtered by faculties)
  - Multiple Level selection (deduplicated across departments)
  - Single Course selection
- QR Code generation with 5-second auto-refresh
- Duplicate scan prevention
- End/Terminate attendance sessions
- View attendance records with Print PDF and Download CSV options

### Student Portal
- QR code scanner with camera access
- Form submission after scanning
- Device fingerprinting to prevent duplicate submissions
- Cache and localStorage protection against re-submission

## Installation

1. **Upload Files**: Upload all files to your web server's public directory

2. **Set Permissions**: Ensure the `data` directory is writable:
   ```bash
   chmod 755 data
   chmod 755 data/attendance
   ```

3. **Configure Apache**: Ensure mod_rewrite is enabled:
   ```bash
   sudo a2enmod rewrite
   sudo service apache2 restart
   ```

4. **Update .htaccess**: If needed, update RewriteBase in .htaccess to match your installation path

## Default Credentials

### Admin
- Email: `admin@attendance.com`
- Password: `admin123`

**Important**: Change these credentials in `config.php` before production use!

## URL Routes

Configure routes in `routes.php`. Default routes:

| URL Path | Description |
|----------|-------------|
| `/` | Home page |
| `/admin` | Admin login |
| `/admin/dashboard` | Admin dashboard |
| `/lecturer` | Lecturer login |
| `/lecturer/register` | Lecturer registration |
| `/studentattendance` | Student QR scanner |

### Customizing Routes

Edit `routes.php` to change URL paths:
```php
$routes = [
    'studentattendance' => 'student/scan.php',  // Change 'studentattendance' to your preferred path
    // ... other routes
];
```

## File Storage

All data is stored in JSON and CSV files:

- `data/admin.json` - Admin credentials
- `data/lecturers.json` - Lecturer accounts
- `data/faculties.json` - Faculty list
- `data/departments.json` - Department list
- `data/levels.json` - Level list
- `data/courses.json` - Course list
- `data/attendance/*.csv` - Attendance records

### Attendance File Naming

Files are named: `{date}_{time}_{faculty}_{department}_{course}_{lecturer}.csv`

Example: `2024-01-15_10-30-00_Science_Computer-Science_CSC101_John-Doe.csv`

## Security Features

- Password hashing with PHP's `password_hash()`
- Session-based authentication
- Input sanitization
- Device fingerprinting for students
- QR code expiration (5 seconds)
- Duplicate submission prevention

## Browser Support

- Chrome (recommended)
- Firefox
- Safari
- Edge
- Mobile browsers with camera support

## Requirements

- PHP 7.4 or higher
- Apache with mod_rewrite enabled
- Write permissions for data directory

## Troubleshooting

### QR Scanner Not Working
- Ensure HTTPS is enabled (required for camera access)
- Grant camera permissions when prompted
- Try using a different browser

### Routes Not Working
- Enable mod_rewrite: `sudo a2enmod rewrite`
- Check AllowOverride is set to All in Apache config
- Verify .htaccess file is present

### Data Not Saving
- Check write permissions on data directory
- Ensure PHP has write access

## License

This project is provided as-is for educational purposes.